<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../../../../gUtil/GestoreUpload.php";
    include "../../../../gUtil/ElaboratoreImmagini.php";
    include "../classi/GrigliaContenuti.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $griglia = new GrigliaContenuti($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $griglia = new GrigliaContenuti($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $griglia->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $griglia->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $griglia->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $griglia->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $griglia->setAnimazioneOnHover(filter_input(INPUT_POST,"animazioneOnHover",FILTER_SANITIZE_STRING));
            $griglia->crea();
            header("Location: ../creaGriglia.php?id={$griglia->getId()}&status=200");
            break;
        case 'modifica':
            $griglia->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $griglia->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $griglia->setDescrizione(filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES));
            $griglia->setClasseElementi(filter_input(INPUT_POST,"classeElementi",FILTER_SANITIZE_STRING));
            $griglia->setAnimazioneOnHover(filter_input(INPUT_POST,"animazioneOnHover",FILTER_SANITIZE_STRING));
            $griglia->modifica();
            header("Location: ../creaGriglia.php?id={$griglia->getId()}&status=250");
            break;
        case 'elimina':
            $griglia->elimina();
            echo "ok";
            break;
        case 'duplica':
            $griglia->caricaDatiDalDatabase();
            $idNuovaForm = $griglia->duplica();
            header("Location: ../creaGriglia.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $griglia->duplicaElemento(filter_input(INPUT_GET,"idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'creaElemento':
            $nome = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $link = filter_input(INPUT_POST, "link",FILTER_SANITIZE_STRING);
            $griglia->creaElemento($nome,$link);
            echo "ok";
            break;
        case 'spostaElemento':
            $griglia->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento     = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $nome           = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
            $link           = filter_input(INPUT_POST,"link",FILTER_SANITIZE_STRING);
            $descrizione    = filter_input(INPUT_POST,"descrizione",FILTER_SANITIZE_ADD_SLASHES);
            $tagAltImmagine = filter_input(INPUT_POST,"tagAltImmagine",FILTER_SANITIZE_STRING);
            $griglia->modificaElemento($idElemento,$nome, $link, $descrizione,$tagAltImmagine);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'stampaElementi':
            $griglia->stampaElementi();
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/webp","image/gif","video/mp4");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/altro", 0);
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $griglia->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $griglia->cambiaImmagineElemento($idElemento,'');
            echo "ok";
            break;
        case 'modificaImmagineElementoConPercorso':
            $idElemento = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $percorso   = filter_input(INPUT_POST, "percorso",FILTER_SANITIZE_STRING);
            $griglia->cambiaImmagineElemento($idElemento,$percorso);
            echo "ok";
            break;
        case 'eliminaElemento':
            $griglia->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }